/*
 * Decompiled with CFR 0.152.
 */
package com.transfereasy.wisecashier;

import com.google.gson.Gson;
import com.transfereasy.wisecashier.error.APIConnectionException;
import com.transfereasy.wisecashier.util.WiseCashierSignature;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Signature;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiseCashier {
    public static final String CHARSET = "UTF-8";
    public static int CONNECT_TIMEOUT = 30;
    public static int READ_TIMEOUT = 80;
    private String ROOT_URL = "https://api.wisecashier.com";
    private static String VERSION = "1.0";
    private String privateKey = null;
    private String merchantNo = null;

    public WiseCashier(String merchantNo, String privateKey, boolean debug) throws IOException {
        if (privateKey.startsWith("-----BEGIN")) {
            this.privateKey = privateKey;
        } else {
            FileInputStream inputStream = new FileInputStream(privateKey);
            byte[] keyBytes = new byte[inputStream.available()];
            inputStream.read(keyBytes);
            inputStream.close();
            this.privateKey = new String(keyBytes, CHARSET);
        }
        this.merchantNo = merchantNo;
        this.ROOT_URL = debug ? "https://testapi.wisecashier.com" : "https://api.wisecashier.com";
    }

    public static String currentTimeString() {
        Integer requestTime = (int)(System.currentTimeMillis() / 1000L);
        return requestTime.toString();
    }

    protected static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET).replaceAll("\\+", "%20");
    }

    private static String map2String(TreeMap<String, Object> sortedParams) throws UnsupportedEncodingException {
        String result = "";
        Set<String> keys = sortedParams.keySet();
        for (String key : keys) {
            result = result + WiseCashier.urlEncode(key) + "=" + WiseCashier.urlEncode(sortedParams.get(key).toString()) + "&";
        }
        return result.substring(0, result.length() - 1);
    }

    private static String mapToPostBody(Map<String, Object> Params) throws UnsupportedEncodingException {
        String result = "";
        Set<String> keys = Params.keySet();
        for (String key : keys) {
            result = result + key + "=" + Params.get(key).toString() + "&";
        }
        return result.substring(0, result.length() - 1);
    }

    private static String map2String4verfiy(Map<String, Object> params) throws UnsupportedEncodingException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>();
        sortedParams.putAll(params);
        Set keys = sortedParams.keySet();
        String result = "";
        for (String key : keys) {
            result = result + key + "=" + sortedParams.get(key).toString() + "&";
        }
        return result.substring(0, result.length() - 1);
    }

    private static String sortedStrParams(Map params) throws UnsupportedEncodingException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>();
        sortedParams.putAll(params);
        return WiseCashier.map2String(sortedParams);
    }

    private String generateSign(String strParams, String requestTime) throws IOException {
        strParams = strParams + "," + requestTime;
        return WiseCashierSignature.sign(strParams, this.privateKey, CHARSET);
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private HttpsURLConnection createGetConnectionV2(String url, Map<String, Object> params, String version) throws IOException, APIConnectionException {
        String requestTime = WiseCashier.currentTimeString();
        String strParams = WiseCashier.sortedStrParams(params);
        String signature = this.generateSign(strParams, requestTime);
        String fullUrl = url + "?" + strParams;
        URL wisecashierUrl = new URL(fullUrl);
        HttpsURLConnection conn = (HttpsURLConnection)wisecashierUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("MerchantNo", this.merchantNo);
        conn.setRequestProperty("Signature", signature);
        conn.setRequestProperty("Version", version);
        conn.setRequestProperty("Timestamp", requestTime);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection createPostConnectionV2(String url, Map<String, Object> params, String version) throws IOException, APIConnectionException {
        String requestTime = WiseCashier.currentTimeString();
        String strParams = WiseCashier.sortedStrParams(params);
        String signature = this.generateSign(strParams, requestTime);
        URL wisecashierUrl = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)wisecashierUrl.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        conn.setRequestProperty("MerchantNo", this.merchantNo);
        conn.setRequestProperty("Signature", signature);
        conn.setRequestProperty("Version", version);
        conn.setRequestProperty("Timestamp", requestTime);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(WiseCashier.mapToPostBody(params).getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        conn.disconnect();
        return conn;
    }

    public String requestV2(RequestMethod method, String url, Map<String, Object> params, String version) throws APIConnectionException, IOException {
        HttpsURLConnection conn = null;
        switch (method) {
            case GET: {
                conn = this.createGetConnectionV2(url, params, version);
                break;
            }
            case POST: {
                conn = this.createPostConnectionV2(url, params, version);
                break;
            }
            default: {
                throw new APIConnectionException(String.format("Unrecognized HTTP method %s. ", new Object[]{method}));
            }
        }
        int rCode = conn.getResponseCode();
        String rMsg = WiseCashier.getResponseBody(conn.getInputStream());
        return rMsg;
    }

    private HttpsURLConnection createGetConnection(String url, Map<String, Object> params) throws IOException, APIConnectionException {
        String requestTime = WiseCashier.currentTimeString();
        String strParams = WiseCashier.sortedStrParams(params);
        String signature = this.generateSign(strParams, requestTime);
        String fullUrl = url + "?" + strParams;
        URL wisecashierUrl = new URL(fullUrl);
        HttpsURLConnection conn = (HttpsURLConnection)wisecashierUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("MerchantNo", this.merchantNo);
        conn.setRequestProperty("Signature", signature);
        conn.setRequestProperty("Version", VERSION);
        conn.setRequestProperty("Timestamp", requestTime);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection createPostConnection(String url, Map<String, Object> params) throws IOException, APIConnectionException {
        String requestTime = WiseCashier.currentTimeString();
        String strParams = WiseCashier.sortedStrParams(params);
        String signature = this.generateSign(strParams, requestTime);
        URL wisecashierUrl = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)wisecashierUrl.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        conn.setRequestProperty("MerchantNo", this.merchantNo);
        conn.setRequestProperty("Signature", signature);
        conn.setRequestProperty("Version", VERSION);
        conn.setRequestProperty("Timestamp", requestTime);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(WiseCashier.mapToPostBody(params).getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        conn.disconnect();
        return conn;
    }

    public String request(RequestMethod method, String url, Map<String, Object> params) throws APIConnectionException, IOException {
        HttpsURLConnection conn = null;
        switch (method) {
            case GET: {
                conn = this.createGetConnection(url, params);
                break;
            }
            case POST: {
                conn = this.createPostConnection(url, params);
                break;
            }
            default: {
                throw new APIConnectionException(String.format("Unrecognized HTTP method %s. ", new Object[]{method}));
            }
        }
        int rCode = conn.getResponseCode();
        String rMsg = WiseCashier.getResponseBody(conn.getInputStream());
        return rMsg;
    }

    public Map wxJsPay(Map params) throws Exception {
        String url = this.ROOT_URL + "/order/js_pay";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map wxScanPay(Map params) throws Exception {
        String url = this.ROOT_URL + "/order/scan_pay";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map wxScanndepay(Map params) throws Exception {
        String url = this.ROOT_URL + "/order/scanned_pay";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map wxRefund(Map params) throws Exception {
        String url = this.ROOT_URL + "/refund";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map wxQueryOrder(Map params) throws Exception {
        String url = this.ROOT_URL + "/order";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.GET, url, params), Map.class);
        return map;
    }

    public Map wxQueryRate(Map params) throws Exception {
        String url = this.ROOT_URL + "/rate";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.GET, url, params), Map.class);
        return map;
    }

    public Map aliScannedPay(Map params) throws Exception {
        String url = this.ROOT_URL + "/alipay/scanned_pay";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map aliWapPay(Map params) throws Exception {
        String url = this.ROOT_URL + "/alipay/wap_pay";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public Map aliQueryOrder(Map params) throws Exception {
        String url = this.ROOT_URL + "/alipay/order";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.GET, url, params), Map.class);
        return map;
    }

    public Map aliRefund(Map params) throws Exception {
        String url = this.ROOT_URL + "/alipay/refund";
        Gson gson = new Gson();
        Map map = gson.fromJson(this.request(RequestMethod.POST, url, params), Map.class);
        return map;
    }

    public String downloadBillV1(Map params) throws Exception {
        String url = this.ROOT_URL + "/download_bill";
        return this.request(RequestMethod.GET, url, params);
    }

    public String downloadBillV2(Map params) throws Exception {
        String url = this.ROOT_URL + "/download_bill";
        return this.requestV2(RequestMethod.GET, url, params, "2.0");
    }

    public String downloadBillV3(Map params) throws Exception {
        String url = this.ROOT_URL + "/download_bill";
        System.out.println(this.ROOT_URL);
        return this.requestV2(RequestMethod.GET, url, params, "3.0");
    }

    public Boolean verify(Map params, String sign, String timestamp, String publicKey) throws Exception {
        String strParams = WiseCashier.map2String4verfiy(params) + ',' + timestamp;
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(WiseCashierSignature.getPublicKey(publicKey));
        signature.update(strParams.getBytes(CHARSET));
        return signature.verify(Base64.decodeBase64(sign));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestMethod {
        GET,
        POST;

    }
}

